<?php

/* * *******************************************************************************
 * The content of this file is subject to the PDF Maker Free license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class PDFMaker {

    private $version_type;
    private $basicModules;
    private $pageFormats;
    var $log;
    var $db;

    // constructor of PDFMaker class
    function __construct() {
        $this->log = LoggerManager::getLogger('account');
        $this->db = PearDatabase::getInstance();

        // array of modules that are allowed for basic version type
        $this->basicModules = array("20", "21", "22", "23");
        $this->name = "PDFMaker";
        $this->id = getTabId("PDFMaker");
    }


    function vtlib_handler($modulename, $event_type) {
        switch ($event_type) {
            case 'module.postinstall':
                $this->executeSql();
                break;
            case 'module.preupdate':
                $res = @$this->db->pquery("SHOW COLUMNS FROM vtiger_pdfmaker_settings", array());
                $is_there = false;
                if ($res) {
                    while ($row = $this->db->fetchByAssoc($res)) {
                        if ($row['field'] == 'is_portal') {
                            $is_there = true;
                            break;
                        }
                    }
                }
                if (!$is_there) {
                    $this->db->pquery("ALTER TABLE `vtiger_pdfmaker_settings` ADD `is_portal` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `file_name`", array());
                }
                $res = @$this->db->pquery("SHOW COLUMNS FROM vtiger_pdfmaker_settings", array());
                $is_there = false;
                if ($res) {
                    while ($row = $this->db->fetchByAssoc($res)) {
                        if ($row['field'] == 'is_listview') {
                            $is_there = true;
                            break;
                        }
                    }
                }
                if (!$is_there) {
                    $this->db->pquery("ALTER TABLE `vtiger_pdfmaker_settings` ADD `is_listview` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER `is_portal`", array());
                }
                break;
            case 'module.postupdate':

                $this->db->pquery("UPDATE vtiger_links SET linkurl = ?  WHERE linklabel = ? AND linktype = ? AND linkurl = ?", array('layouts/v7/modules/PDFMaker/resources/PDFMakerFreeActions.js', 'PDFMakerJS', 'HEADERSCRIPT', 'modules/PDFMaker/PDFMakerActions.js'));
                $this->db->pquery("DELETE FROM vtiger_links WHERE linklabel = ? AND linktype = ? AND linkurl LIKE ?", array( 'PDF Export', 'LISTVIEWBASIC', '%getPDFListViewPopup2%'));
                $this->db->pquery("DELETE FROM vtiger_links  WHERE linklabel = ? AND linktype = ? AND linkurl = ? ", array( 'PDFMaker', 'DETAILVIEWWIDGET', 'module=PDFMaker&action=PDFMakerAjax&file=getPDFActions&record=$RECORD$'));

                $res = $this->db->pquery("SELECT * FROM vtiger_profile2standardpermissions WHERE tabid=(SELECT tabid FROM vtiger_tab WHERE name = ?)",array('PDFMaker'));
                if ($this->db->num_rows($res) > 0) {
                    $res = $this->db->pquery("SELECT * FROM vtiger_pdfmaker_profilespermissions",array());
                    if ($this->db->num_rows($res) == 0) {
                        $this->db->pquery("INSERT INTO vtiger_pdfmaker_profilespermissions SELECT profileid, operation, permissions FROM vtiger_profile2standardpermissions WHERE tabid = (SELECT tabid FROM vtiger_tab WHERE name = ?)",array('PDFMaker'));
                    }
                    $this->db->pquery("DELETE FROM vtiger_profile2standardpermissions WHERE tabid = (SELECT tabid FROM vtiger_tab WHERE name = ?)",array('PDFMaker'));
                }

                $this->DeleteAllRefLinks();

                break;
            case 'module.preuninstall':
                $this->removeLinks();
                break;
            case 'module.enabled':

                break;
        }

    }

    public function executeSql() {
        if ($this->db->num_rows($this->db->pquery("SELECT id FROM vtiger_pdfmaker_seq", array())) < 1) {
            $this->db->pquery("INSERT INTO vtiger_pdfmaker_seq VALUES (?)", array('0'));
        }

        $productblocData = "INSERT INTO `vtiger_pdfmaker_productbloc_tpl` (`id`, `name`, `body`) VALUES
					(1, 'Product block for group tax', 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),
					(2, 'Product block for individual tax', 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)";
        $this->db->pquery($productblocData, array());

        $pdfmakerData1 = "INSERT INTO `vtiger_pdfmaker` (`templateid`, `filename`, `module`, `body`, `description`, `deleted`) VALUES
(1, 'Invoice', 'Invoice', 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, 'Template for Invoice', 0)";

        $this->db->pquery($pdfmakerData1, array());


        $pdfmakerData2 = "INSERT INTO `vtiger_pdfmaker` (`templateid`, `filename`, `module`, `body`, `description`, `deleted`) VALUES (2, 'SalesOrder', 'SalesOrder', 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, 'Template for SalesOrder', 0)";

        $this->db->pquery($pdfmakerData2, array());

        $pdfmakerData3 = "INSERT INTO `vtiger_pdfmaker` (`templateid`, `filename`, `module`, `body`, `description`, `deleted`) VALUES
(3, 'PurchaseOrder', 'PurchaseOrder', 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, 'Template for PurchaseOrder', 0)";

        $this->db->pquery($pdfmakerData3, array());

        $pdfmakerData4 = "INSERT INTO `vtiger_pdfmaker` (`templateid`, `filename`, `module`, `body`, `description`, `deleted`) VALUES (4, 'Quotes', 'Quotes', 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, 'Templates for Quotes', 0)";

        $this->db->pquery($pdfmakerData4, array());

        $settingsSql = "INSERT INTO `vtiger_pdfmaker_settings` (`templateid`, `margin_top`, `margin_bottom`, `margin_left`, `margin_right`, `format`, `orientation`, `decimals`, `decimal_point`, `thousands_separator`, `header`, `footer`, `encoding`, `file_name`, `is_portal`, `is_listview`, `owner`, `sharingtype`, `disp_header`, `disp_footer`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

        $settingsData1 = array(1, 2.0, 2.0, 2.0, 2.0, 'A4', 'portrait', 2, ',', '.', '<html><head>	<title></title></head><body><table border="0" cellpadding="0" cellspacing="0" class="header" width="100%"><tbody>		<tr><td align="left" valign="top">$COMPANY_LOGO$</td><td align="right" nowrap="nowrap" valign="top"><h1><span style="color: rgb(0, 0, 0); font-family: mitra; font-size: x-large; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: bold; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">%M_Invoice No% $INVOICE_INVOICE_NO$</span></h1></td></tr></tbody></table></body></html>', '<html><head><title></title></head><body><p style="text-align: center;"><span style="font-size:10px;">$COMPANY_NAME$ <small>&bull; </small>$COMPANY_ADDRESS$ <small>&bull; </small> $COMPANY_ZIP$<small> </small>$COMPANY_CITY$<small> &bull; </small>$COMPANY_STATE$</span></p></body></html>', 'auto', NULL, 0, 0, 1, 'public', 3, 7);

        $this->db->pquery($settingsSql, $settingsData1);

        $settingsData2 = array(2, 2.0, 2.0, 2.0, 2.0, 'A4', 'portrait', 2, ',', '', '<html><head><title></title></head><body><table border="0" cellpadding="0" cellspacing="0" class="header" width="100%"><tbody><tr><td align="left" valign="top">$COMPANY_LOGO$</td><td align="right" nowrap="nowrap" valign="top"><h1><span style="color: rgb(0, 0, 0); font-family: mitra; font-size: x-large; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: bold; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">%SALESORDER_SALESORDER_NO% $SALESORDER_SALESORDER_NO$</span></h1></td></tr></tbody></table></body></html>', '<html><head><title></title></head><body><p style="text-align: center;"><span style="font-size:10px;">$COMPANY_NAME$ <small>&bull; </small>$COMPANY_ADDRESS$ <small>&bull; </small> $COMPANY_ZIP$<small> </small>$COMPANY_CITY$<small> &bull; </small>$COMPANY_STATE$</span></p></body></html>', 'auto', NULL, 0, 0, 1, 'public', 3, 7);

        $this->db->pquery($settingsSql, $settingsData2);

        $settingsData3 = array(3, 2.0, 2.0, 2.0, 2.0, 'A4', 'portrait', 2, ',', '', '<html><head><title></title></head><body><table border="0" cellpadding="0" cellspacing="0" class="header" width="100%"><tbody><tr><td align="left" valign="top">$COMPANY_LOGO$</td><td align="right" nowrap="nowrap" valign="top">	<h1><span style="color: rgb(0, 0, 0); font-family: mitra; font-size: x-large; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: bold; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">%PURCHASEORDER_PURCHASEORDER_NO% $PURCHASEORDER_PURCHASEORDER_NO$</span></h1></td></tr></tbody></table></body></html>', '<html><head><title></title></head><body><p style="text-align: center;"><span style="font-size:10px;">$COMPANY_NAME$ <small>&bull; </small>$COMPANY_ADDRESS$ <small>&bull; </small> $COMPANY_ZIP$<small> </small>$COMPANY_CITY$<small> &bull; </small>$COMPANY_STATE$</span></p></body></html>', 'auto', NULL, 0, 0, 1, 'public', 3, 7);

        $this->db->pquery($settingsSql, $settingsData3);

        $settingsData4 = array(4, 2.0, 2.0, 2.0, 2.0, 'A4', 'portrait', 2, ',', '', '<html><head>	<title></title></head><body><table border="0" cellpadding="0" cellspacing="0" class="header" width="100%"><tbody>		<tr><td align="left" valign="top">$COMPANY_LOGO$</td><td align="right" nowrap="nowrap" valign="top"><h1><span style="color: rgb(0, 0, 0); font-family: mitra; font-size: x-large; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: bold; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">%M_Quote No% $QUOTES_QUOTE_NO$</span></h1></td></tr></tbody></table></body></html>', '<html><head>	<title></title></head><body><p style="text-align: center;"><span style="font-size:10px;">$COMPANY_NAME$ <small>&bull; </small>$COMPANY_ADDRESS$ <small>&bull; </small> $COMPANY_ZIP$<small> </small>$COMPANY_CITY$<small> &bull; </small>$COMPANY_STATE$</span></p></body></html>', 'auto', NULL, 0, 0, 1, 'public', 3, 7);

        $this->db->pquery($settingsSql, $settingsData4);
        $seqUpdate = "UPDATE vtiger_pdfmaker_seq SET id='4' WHERE id='0'";
        $this->db->pquery($seqUpdate, array());

        $this->AddLinks("Quotes");
        $this->AddLinks("SalesOrder");
        $this->AddLinks("PurchaseOrder");
        $this->AddLinks("Invoice");

        $this->db->pquery("INSERT INTO vtiger_pdfmaker_releases (version, date, updated) VALUES(?, NOW(), 1)", array(PDFMaker_Version_Helper::$version));
    }

    public function AddLinks($modulename) {
        require_once('vtlib/Vtiger/Module.php');
        $link_module = Vtiger_Module::getInstance($modulename);
        //$link_module->addLink('DETAILVIEWWIDGET', 'PDFMaker', 'module=PDFMaker&action=PDFMakerAjax&file=getPDFActions&record=$RECORD$');
        $link_module->addLink('DETAILVIEWSIDEBARWIDGET', 'PDFMaker', 'module=PDFMaker&view=GetPDFActions&record=$RECORD$');
        if ($modulename != "Events") $link_module->addLink('LISTVIEWMASSACTION', 'PDF Export', 'javascript:PDFMaker_Actions_Js.getPDFListViewPopup2(this,\'$MODULE$\');');
        // remove non-standardly created links (difference in linkicon column makes the links twice when updating from previous version)
        global $adb;
        $tabid = getTabId($modulename);
        $res = $adb->pquery("SELECT * FROM vtiger_links WHERE tabid=? AND linktype=? AND linklabel=? AND linkurl=? ORDER BY linkid DESC", array($tabid, 'DETAILVIEWWIDGET', 'PDFMaker', 'module=PDFMaker&action=PDFMakerAjax&file=getPDFActions&record=$RECORD$'));
        $i = 0;
        while ($row = $adb->fetchByAssoc($res)) {
            $i++;
            if ($i > 1)
                $adb->pquery("DELETE FROM vtiger_links WHERE linkid=?", array($row['linkid']));
        }
        $res = $adb->pquery("SELECT * FROM vtiger_links WHERE tabid=? AND linktype=? AND linklabel=? AND linkurl=? ORDER BY linkid DESC", array($tabid, 'LISTVIEWMASSACTION', 'PDF Export', 'javascript:getPDFListViewPopup2(this,\'$MODULE$\');'));
        $i = 0;
        while ($row = $adb->fetchByAssoc($res)) {
            $i++;
            if ($i > 1)
                $adb->pquery("DELETE FROM vtiger_links WHERE linkid=?", array($row['linkid']));
        }

        if ($modulename == "Calendar") $this->AddLinks('Events');
    }


    public function removeLinks() {
        require_once('vtlib/Vtiger/Link.php');

        $tabid = getTabId("PDFMaker");
        Vtiger_Link::deleteAll($tabid);
        $this->DeleteAllRefLinks();
    }

    public function DeleteAllRefLinks() {
        require_once('vtlib/Vtiger/Link.php');
        $link_res = $this->db->pquery("SELECT tabid FROM vtiger_tab WHERE isentitytype = ?", array('1'));
        while ($link_row = $this->db->fetchByAssoc($link_res)) {
            Vtiger_Link::deleteLink($link_row["tabid"], "DETAILVIEWWIDGET", "PDFMaker");
            Vtiger_Link::deleteLink($link_row["tabid"], "DETAILVIEWSIDEBARWIDGET", "PDFMaker");
            Vtiger_Link::deleteLink($link_row["tabid"], "LISTVIEWMASSACTION", "PDF Export", 'javascript:getPDFListViewPopup2(this,\'$MODULE$\');');
            Vtiger_Link::deleteLink($link_row["tabid"], "LISTVIEWMASSACTION", "PDF Export", "javascript:PDFMaker_Actions_Js.getPDFListViewPopup2(this,'$"."MODULE$');");
        }
    }

    //Getters and Setters
    public function GetVersionType() {
        return $this->version_type;
    }

    public function GetPageFormats() {
        return $this->pageFormats;
    }

    public function GetBasicModules() {
        return $this->basicModules;
    }
}
